function [r,dl,Nd] = rectangle_distribution_dipoles(a, b, c, N, pos0)

% This function obtains the position of the dipoles resulting from
% discretizing a in a cubic net a parallelepiped in N punctual dipoles.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% a,b and c: sides length of the parallelepiped                   %%%
%%% N:         number of dipoles inside the scatterer               %%%
%%% pos0:      position of the center of mass of the parallelepiped %%%

%%%%%% OUTUT ARGUMENTS %%%%%%
%%% r: (Nd,3) vector containing the 3D positions of the Nd dipoles  %%%
%%% dl:        lattice parametwr of the resulting net               %%%


dl = (a*b*c/N)^(1/3);  %%% Lattice constant


%%%% Generation of coordinates %%%%
x = -(a-dl)/2:dl:(a-dl)/2;
y = -(b-dl)/2:dl:(b-dl)/2;
z = -(c-dl)/2:dl:(c-dl)/2;

[XXX,YYY,ZZZ] = meshgrid(x,y,z);
X(:) = XXX(1:numel(XXX));
Y(:) = YYY(1:numel(YYY));
Z(:) = ZZZ(1:numel(ZZZ));

%%%% Displacing the center of mass %%%%
r(:,1) = X(:)+pos0(1);
r(:,2) = Y(:)+pos0(2);
r(:,3) = Z(:)+pos0(3);

%%%% Resulting number of dipoles %%%%
Nd = length(r(:,1));


end

